<?php
// voorbereiding *************************************************
// include de functies voor de controller, algemene settings en voor de model
include("controller/controller_functions.php");
include("controller/settings.php");
include("model/model_functions.php");

// Model aanroep *************************************************
// check of er een pagina is gepost ($ post_pag is leeg of bevat de id van dat formulier)
$post_pag = f_post_pag();
if($post_pag != ""){
  // let op: in de map model moet dus een bestand zitten met de naam model_xxx, waarbij xxx de id is
  // die in het formulier in de input type hidden zit
  // toch maar ff check of het bestand er is
  if(file_exists("model/model_$post_pag.php")){
    include("model/model_$post_pag.php");
  }else{
    // foutmelding geven en ook de code uitvoering gelijk stoppen
    die("Het bestand model_$post_pag.php ontbreekt");
  }
}

// View aanroep **************************************************
// altijd kopje van de html pagina includen
include("view/1_head.php");

// check of er een pagina is opgevraagd: $get_pag bevat de startpagina of id van opgevraagde pagina
$get_pag = f_get_pag();

// altijd de html die in de body moet komen opvragen
// let op: in de map view moet dus een bestand zitten met de naam 2_xxx, waarbij xxx de id is die in het menu zat
// toch maar ff check of het bestand er is
if(file_exists("view/2_$get_pag.php")){
  include("view/2_$get_pag.php");
}else{
  // foutmelding geven
  echo "Het bestand view/2_$get_pag.php ontbreekt";
}

// en afsluiten met slot
include("view/3_end.php");
