<?php
// demo tekst ophalen die overeenkomst met zoekwoord
// verzend invoer in tekstveld naar de server
// server stuurt lijst met overeenkomende waarden terug
// (feitelijk: de google lijst aanvulfunctie)

// check of er een json bericht is verstuurd, via normale $_POST check
if(isset($_POST['search'])){
  // yes, is verstuurd

  // array in php aangemaakt, moet normaal uit de database worden gehaald
  $tekst = array();
  $n = 0;
  $tekst[$n] = "waarde";
  $n++;
  $tekst[$n] = "waarom";
  $n++;
  $tekst[$n] = "water";
  $n++;
  $tekst[$n] = "weer";
  $n++;
  $tekst[$n] = "wezenlijk";
  $n++;
  $tekst[$n] = "wieken";
  $n++;
  $tekst[$n] = "wilde";
  $n++;
  $tekst[$n] = "wit";
  $n++;
  $tekst[$n] = "wolken";
  $n++;
  $tekst[$n] = "wonderen";
  $n++;
  $tekst[$n] = "wonen";
  $n++;
  $tekst[$n] = "wuiven";
  $n++;

  // het zoekveld
  $search = strtolower(trim($_POST['search']));
  $retour = array();
  if($search != ""){
    $n = 0;
    // lus doorlopen, check wat zelfde begin heeft
    for($i = 0; $i < count($tekst); $i++){
      if(strpos($tekst[$i], $search) > -1){
        $retour[$n] = $tekst[$i];
        $n++;
        // de lijst mag max 10 waarden bevatten
        if($n > 9){
          break;
        }
      }
    }
  }
  // versturen
  echo json_encode($retour);
  // code stoppen, anders wordt alle html hieronder ook verstuurd
  die();
}
?>
<!DOCTYPE html>
<html>
<head>
    <script>
        var result_choosen = -1;

        function send_search() {
            // niet als pijl omhoog, pijl omlaag of enter is gebruikt
            var e = window.event;
            if ((e.keyCode == 38) || (e.keyCode == 40) || (e.keyCode == 13)) {
                return;
            }

            var oReq = new XMLHttpRequest();
            oReq.onload = ajaxSuccess;
            oReq.open("post", "index.php", true);
            var params = new FormData;
            params.append('search', document.getElementById('search').value);
            oReq.send(params);
        }

        // aanroep door server, geinitialiseerd in AJAXSubmit
        function ajaxSuccess() {
            var response_text;
            var search_result = '';
            var class_deze;

            // retourbericht van de server opvangen, via try catch
            try {
                response_text = JSON.parse(this.responseText);
            } catch (e) {
                // e bevat de javascript tekst van het foutbericht
                // vaak geeft this.responseText meer info: dit is het gehele bericht van de server
                alert('fout in json retourbericht, melding:\n' + e + '\ntekst:\n' + this.responseText);
                return;
            }

            // alleen als er resultaat is, dan via lijst tonen
            if (response_text.length > 0) {
                // er is resultaat
                // TODO: WELLICHT ONCLICK OP UL, DAN LI INNERHTML?
                // tekstvak andere class
                document.getElementById("search").classList.remove('uloff');
                document.getElementById("search").classList.add('ulon');
                //ulon
                // ul toevoegen
                search_result = '<ul class="ul" id="result_ul">';
                // lus over alle resultaten
                for (i = 0; i < response_text.length; i++) {
                    // er moet een onclick op elke li
                    class_deze = 'li';
                    if(i == response_text.length - 1){
                        class_deze = 'lilast';
                    }
                    search_result = search_result + '<li class="' + class_deze + '" id="result_' + i + '" onclick="get_word(\'' + response_text[i] + '\')">' + response_text[i] + '</li>';
                }
                // eind ul
                search_result = search_result + '</ul>';
                // output div vullen en zichtbaar maken
                document.getElementById('output').innerHTML = search_result;
                document.getElementById('output').style.display = 'block';
            } else {
                // geen resultaten, output div leeg maken en verbergen
                hide_output();
            }
        }

        // aanroep via onclick in de lijst met output
        function get_word(text) {
            // tekstvak weer andere class
            document.getElementById("search").classList.remove('ulon');
            document.getElementById("search").classList.add('uloff');
            // neem gekozen text over in het tekstvak
            document.getElementById('search').value = text;
            // done, dus output div verbergen
            hide_output();
            result_choosen = -1;
        }

        // bij pijl omlaag/omhoog de keuze highlighten
        function up_down() {
            // alleen bij focus op search veld
            var selectedTextArea = document.activeElement;
            if (selectedTextArea.id != 'search') {
                return;
            }
            var e = window.event;
            var result_choosen_next;
            if (e.keyCode == 8) {
                result_choosen = -1;
            }
            if (e.keyCode == 38) {
                // up
                if (result_choosen > 0) {
                    // teller 1 naar boven
                    document.getElementById('result_' + result_choosen).style.backgroundColor = '#ffffff';
                    result_choosen--;
                    // opnemen in tekstvak
                    document.getElementById('search').value = document.getElementById('result_' + result_choosen).innerHTML;
                    // en achtergrond kleuren
                    document.getElementById('result_' + result_choosen).style.backgroundColor = '#eeeeee';
                }
            }
            if (e.keyCode == 40) {
                // down
                result_choosen_next = result_choosen + 1;
                if (document.getElementById('result_' + result_choosen_next) != undefined) {
                    // vorige weer normaal, als niet -1
                    if (result_choosen > -1) {
                        document.getElementById('result_' + result_choosen).style.backgroundColor = '#ffffff';
                    }
                    // teller 1 naar onder
                    result_choosen++;
                    // opnemen in tekstvak
                    document.getElementById('search').value = document.getElementById('result_' + result_choosen).innerHTML;
                    // en achtergrond kleuren
                    document.getElementById('result_' + result_choosen).style.backgroundColor = '#eeeeee';
                }
            }
            if (e.keyCode == 13) {
                // enter
                if (document.getElementById('result_' + result_choosen) != undefined) {
                    get_word(document.getElementById('result_' + result_choosen).innerHTML);
                }
            }
        }

        function hide_output() {
            // aanroep door diverse javascript functies en door onclick in body
            // verbergen div output
            document.getElementById('output').style.display = 'none';
            // voor de netheid ook leegmaken, hoeft feitelijk niet voor eindgebruiker
            document.getElementById('output').innerHTML = '';
            // tekstvak weer normaal
            document.getElementById("search").classList.remove('ulon');
            document.getElementById("search").classList.add('uloff');
        }
    </script>
    <!-- beetje opmaak, voor demo ff op type objecten zelf gezet, moet eigenlijk inline of via class op de objecten -->
    <style>
        .inleiding {
            font-family: Arial, Helvetica, sans-serif;
            font-size: 15px;
        }

        .searchtext {
            background-color: transparent;
            border: 1px solid #dbdbdb;
            border-radius: 20px;
            display: flex;
            flex: 100%;
            font-family: Arial, Helvetica, sans-serif;
            font-size: 15px;
            margin: 0;
            outline: none;
            padding: 12px;
            word-wrap: break-word;
            -webkit-tap-highlight-color: transparent;
            width: 192px;
        }

        .uloff {
            border-radius: 20px;
        }

        .ulon {
            border-radius: 20px 20px 0px 0px;
        }

        .ul {
            border: 1px solid #dbdbdb;
            border-radius: 0px 0px 20px 20px;
            font-family: Arial, Helvetica, sans-serif;
            font-size: 15px;
            list-style-type: none;
            margin: 0;
            padding: 0px;
            width: 216px;
        }

        .li {
            padding: 5px 12px 12px 12px;
        }

        .lilast{
            padding: 5px 12px 12px 12px;
            border-radius: 0px 0px 20px 20px;
        }

        .li:hover {
            background-color: #eeeeee;
            cursor: pointer;
        }

        .lilast:hover{
            background-color: #eeeeee;
            cursor: pointer;
        }

        .output {
            display: none;
            width: 200px;
        }
    </style>
</head>
<!-- onclick is nodig om bij klik buiten div met zoekwoorden, deze div te verbergen -->
<body onclick="hide_output()">
<span class="inleiding">Zoek (ivm demo, start met letter 'w')</span><br>
<br>
<!-- het zoekvak, kern is onkeyup, dan javascript aanroepen -->
<input class="searchtext uloff" type="text" id="search" name="search" spellcheck="false" onkeydown="up_down()"
       onkeyup="send_search()">
<!-- de resultaten div, bij start verborgen -->
<div class="output" id="output"></div>

<!-- voor het gemak, voor deze demo, cursor na start gelijk op zoekveld -->
<script>window.onload = function () {
        document.getElementById('search').focus();
    }
</script>
</body>
</html>
